﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IIsShortcutStrategy
    {
        void Write(bool b);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class  IsShortcutDefaultStrategy : ICorrespondenceOS, IIsShortcutStrategy
    {
        public IsShortcutDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsVista_SP3,
#if DEBUG
                                           
                                           OS.WindowsSeven,
                                           OS.WindowsSeven_SP1,
                                           OS.WindowsSeven_SP2
#endif
                                       };
        }

        private string RegName = "IsShortcut";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(bool b)
        {
            RegistryKey registryKey =
                Registry.ClassesRoot.CreateSubKey(
                    @"lnkfile");

            if (b)
            {
            registryKey.SetValue(RegName,"",RegistryValueKind.String);
            }
            else
            {
                registryKey.DeleteValue(RegName);
            }
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.ClassesRoot.OpenSubKey(
                    @"lnkfile");

            if (registryKey.GetValue(RegName)!=null)
            {
                return new WFRegistry(@"HKEY_CLASSES_ROOT\lnkfile", RegName,
                                  "", RegistryValueKind.DWord, RegOperation.KeyWrite);
            }

            return new WFRegistry(@"HKEY_CLASSES_ROOT\lnkfile", RegName,
                                  "", RegistryValueKind.DWord, RegOperation.KeyDel);
            
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class  IsShortcutController
    {
        public IsShortcutController(IsShortcut isShortcut,
                                                         IIsShortcutStrategy strategy)
        {
            IsShortcut = isShortcut;
            Strategy = strategy;
        }

        public IsShortcut IsShortcut { get; set; }
        public IIsShortcutStrategy Strategy { get; set; }

        public void Read()
        {
            if(Strategy.Read().RegOperation== RegOperation.KeyWrite)
            {
                IsShortcut.SetIsShortcutState(false);
            }
            else
            {
                IsShortcut.SetIsShortcutState(true);
            }
        }

        public void Write()
        {
            Strategy.Write(IsShortcut.GetIsShortcutState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
